USE NWIC_PanelMgmt
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE App.NVCC_usp_GetPatient
	@station int,   --station for pt, restricts queries local VA station
	@ssn varchar(9) -- this is the patient's SSN

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name        : NVCC_usp_GetPatient
--Server                : DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-20-2016
--
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Purpose               : To retrieve a single patient record for the NVCC app.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT Cast(patientsid as varchar) as strPatientSID
         ,Sta3n
         ,App.udf_StationName (Sta3n) AS StationName
         ,PatientName
         ,PatientLastName
         ,PatientFirstName
         ,PatientSSN
         ,StreetAddress1
         ,StreetAddress2
         ,StreetAddress3
         ,City
         ,Zip
         ,Zip4
         ,PostalCode
         ,Province
         ,Country
         ,PhoneResidence
         ,PhoneWork
         ,PhoneCellular
         ,DateOfDeath
         ,BadAddressIndicator
         ,TemporaryAddressActiveFlag
         ,Gender
         ,Age
         ,[State]
         ,Deceased
         ,Eligibility
         ,DateOfBirth
         ,IneligibleDate
         ,EligibilityStatus
         ,EligibilityVerificationSource
   FROM  CDWWork.SPatient.SPatient
   WHERE PatientSSN like @ssn and sta3n=@station;
END;

GO
